// BTDSys Machine Use Counter.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <string.h>
#include <windows.h>

typedef unsigned long dword;

struct Smacinfo
{
	char macname[255];
	int usecount;
};

Smacinfo macinfo[1000];

int nummacinfos;

void asciizread (FILE *f, char *buf)
{
	int c=0;
	
	do
	{
		fread(&buf[c], 1,1,f);
		c++;
	}
	while (buf[c-1] != 0);
}

void addmacuse (char *name)
{
	bool found = false;

	for (int i=0; i<nummacinfos; i++)
	{
		if (strcmp(macinfo[i].macname, name) == 0)
		{
			macinfo[i].usecount++;
			found = true;
		}
	}

	if (!found)
	{
		strcpy(macinfo[nummacinfos].macname, name);
		macinfo[nummacinfos].usecount = 1;
		nummacinfos++;
	}
}

int macinfocompare (const void *elem1, const void *elem2)
{
	Smacinfo *m1 = (Smacinfo *)elem1;
	Smacinfo *m2 = (Smacinfo *)elem2;

	return m2->usecount - m1->usecount;
}

int main(int argc, char* argv[])
{
	for (int i=0; i<1000; i++)
	{
		macinfo[i].macname[0] = 0;
		macinfo[i].usecount = 0;
	}
	nummacinfos = 0;

	if (argc != 3)
	{
		cout << "Usage: maccount <song-folder> <txt-file-name>" << endl;
	}
	else
	{
		ofstream fout;
		fout.open(argv[2]);

		char path[256], path2[256];
		strcpy(path, argv[1]);
		if (path[strlen(path)-1] != '\\')
		{
			strcat(path, "\\");
		}
		strcpy(path2, path);
		strcat(path,"*.bm*");
				
		WIN32_FIND_DATA fdata;

		HANDLE hfind = FindFirstFile(
			path,
			&fdata);

		if (hfind != INVALID_HANDLE_VALUE)
		{
			int NumFilesDone = 0;
			int NumFilesNotDone = 0;
			do
			{
				char buf[256];

				char filename[256];
				strcpy(filename, path2);
				strcat(filename, fdata.cFileName);

				cout << filename << endl;

				FILE *fin = fopen(filename, "rb");
				fread(buf, 1, 4, fin);
				buf[4] = 0;
				if (strcmp(buf, "Buzz") == 0) //it's a buzz file
				{
					dword nsects;
					fread(&nsects, sizeof(nsects), 1, fin);
					int PARAoffset = -1;

					for (dword s=0; s<nsects; s++)
					{
						dword offset, size;
						fread(buf,1,4,fin);
						buf[4] = 0;
						fread(&offset,sizeof(offset),1,fin);
						fread(&size,sizeof(size),1,fin);
						if (strcmp(buf, "PARA") == 0)
							PARAoffset = offset;
					}

					if (PARAoffset != -1)
					{
						fseek(fin, PARAoffset, SEEK_SET);

						dword NumMachines;
						fread(&NumMachines, sizeof(NumMachines),1,fin);

						for (dword m=0; m<NumMachines; m++)
						{
							asciizread(fin, buf);	//name
							asciizread(fin, buf);	//type
							addmacuse(buf);

							dword NumP[2];
							fread(NumP, sizeof(dword),2,fin);
							for (dword p=0; p < (NumP[0]+NumP[1]); p++)
							{
								fread(buf,1,1,fin); //type
								asciizread(fin, buf);
								fread(buf, sizeof(int), 5, fin);
							}
						}

						NumFilesDone++;
					}
					else
						NumFilesNotDone++;
				}
				fclose(fin);
			}
			while (FindNextFile(hfind, &fdata) != 0);

			qsort(&macinfo[0], nummacinfos, sizeof(Smacinfo), 
				macinfocompare);

			for (int i=0; i<nummacinfos; i++)
			{
				fout << macinfo[i].usecount << " : " << macinfo[i].macname << endl;
			}

			cout << NumFilesDone << " files done, " << NumFilesNotDone << " not done." << endl;
		}

		FindClose(hfind);
	}


	return 0;
}
